@extends('layouts/main')
@section('page_title')Donation | Apply Now for Staff Nurse & Doctors Job in India at NU Hospitals
@endsection
@section('page_description')Get a chance to build your career with NU Hospitals, we provide tremendous opportunities to
our students to explore, with extensive practical sessions. Visit here for current openings.
@endsection
@section('canonical')https://www.nuhospitals.com/ @endsection
@section('content')
@section('customcss')
<style type="text/css">
.addressbox {
    border: 0px solid;
    margin: 0rem .5rem;
}

@media (min-width: 786px) {
    .addressbox p {
        padding: 0rem 2rem;
    }

    .addressbox h4 {
        padding: 0rem 2rem;
    }
}
nav > div a.nav-item.nav-link.active:after{
    display:none;
}
.donation-form-title{
    font-size:18px;
}

.switch {
  position: relative;
  display: inline-block;
  width: 50px;
  height: 25px;
}

.switch input { 
  opacity: 0;
  width: 0;
  height: 0;
}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 18px;
  width: 18px;
  left: 3px;
  bottom: 3px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #21936a;
}

input:focus + .slider {
  box-shadow: 0 0 1px #21936a;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
.anonymous-donar-wrapper #anonymous-info-msg{
    display:none;
    font-size: 12px;
    font-style: italic;
}
.anonymous-donar-wrapper span{
    font-size:14px;
}
.fixed-donation{
    border: 0;
    background: #f2f2f2;
    padding: 5px 15px;
    font-size: 14px;
    font-weight: 600;
    color: #ec3237;
    margin-right: 10px;
    transition:0.2s;
    cursor: pointer;
}
.fixed-donation:hover,.fixed-donation.active{
    background: #ec3237;
    color: #fff;
    box-shadow: 0px 5px 14px -2px #7575758c;
}
@media only screen and (max-width: 900px){
    .donate-banner-section{
        min-height:auto !important;
    }
    .h1, h1 {
    font-size: 2.2rem !important;
}

}
</style>
@endsection

<!-- Banner Starts -->
<section class="section donate-banner-section">
    <div class="container-fluid">
        <div class="col-md-12 banner-content text-right">
            <h1>Support our campaigns for a
                <br>healthy cause
            </h1>
            <a href="#donation-form-section" class="btn btn-primary btn-rounded mt-3">Donate Now</a>
        </div>
    </div>
</section>
<!-- Banner Ends -->

<!-- Pediatric Section Starts -->

<!-- Education Section Ends -->

<!-- Donate Section Starts -->
<!-- <section class="section home-donation-section">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12 section-title text-center">
                <h2>Support Our Campaigns</h2>
            </div>
        </div>
        <div class="row">
            <div class="col-md-3">
                <div class="col-md-12 home-donation-content-wrapper">
                    <img src="https://nutrust.org/img/donation-images/Pediatric kidney-Transplant.png" alt=""
                        width="100%">
                    <div class="col-md-12 home-donation-content">
                        <h4>Paediatric Kidney Transplant</h4>
                        <p>A child weighing more than 10 kg can get an adult kidney, as long as the kidney fits in their
                            body.</p>

                        <div class="text-center mt-5">
                            <a href="https://nutrust.org/paediatric-kidney-transplant"
                                class="btn btn-primary btn-rounded mt-4">Donate Now</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="col-md-12 home-donation-content-wrapper">
                    <img src="https://nutrust.org/img/donation-images/Adult-Kidney-Transplant-1.png" alt="" width="100%">
                    <div class="col-md-12 home-donation-content">
                        <h4>Adult Kidney Transplant</h4>
                        <p> Renal transplant is carried out for patients with end-stage renal failure that is when the
                            kidney function is irreversibly reduced to below 15% of normal.
                        </p>

                        <div class="text-center mt-5">
                            <a href="https://nutrust.org/adult-kidney-transplant"
                                class="btn btn-primary btn-rounded">Donate Now</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="col-md-12 home-donation-content-wrapper">
                    <img src="https://nutrust.org/img/donation-images/uro-gental.png" alt="" width="100%">
                    <div class="col-md-12 home-donation-content">
                        <h4>Paediatric Uro-genital abnormalities</h4>
                        <p>Paediatric urogenital disorders can affect the urinary tract or reproductive organs in
                            children. If not corrected on time, these conditions may lead to significant mental, social
                            and disability issues.
                        </p>

                        <div class="text-center">
                            <a href="https://nutrust.org/paediatric-uro-genital-abnormalities"
                                class="btn btn-primary btn-rounded">Donate Now</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="col-md-12 home-donation-content-wrapper">
                    <img src="https://nutrust.org/img/donation-images/Education-for-children-1.png" alt="" width="100%">
                    <div class="col-md-12 home-donation-content">
                        <h4>Education for Children</h4>
                        <p> A good quality education helps children reach their full potential however, for millions of
                            children and youth, it is beyond reach.
                        </p>

                        <div class="text-center mt-5">
                            <a href="https://nutrust.org/education-for-children"
                                class="btn btn-primary btn-rounded">Donate Now</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section> -->
<section class="mt-5">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center">
                <h2>DONATE TO SAVE LIVES / GIVE THE GIFT OF HEALTH</h2>
                <p>Our campaigns are focused on treating and curing a wide range of simple and complex
                    Nephrology-Urology related diseases in children and adults from poor socio-economic status. And with
                    a little bit of your help, we can make a huge difference in the lives of many who cannot afford
                    quality care from the experts. </p>
                <a href="#donation-form-section" class="donate-text">Make Your Donation Now</a>
                <p class="text-center">"NU Trust is recognized under Section 80(5)(vi) of the Indian Income Tax Act,
                    1961, for tax exemption"
                </p>
            </div>
        </div>
    </div>
</section>


<section class="mt-5 mb-5">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 w-100">
                <nav>
                    <div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
                        <a class="nav-item nav-link active" id="nav-home-tab" data-toggle="tab" href="#nav-home"
                            role="tab" aria-controls="nav-home" aria-selected="true">Payment Gateway</a>
                        <!-- <a class="nav-item nav-link" id="nav-profile-tab" data-toggle="tab" href="#nav-profile"
                            role="tab" aria-controls="nav-profile" aria-selected="false">Cheque Details</a>
                        <a class="nav-item nav-link" id="nav-contact-tab" data-toggle="tab" href="#nav-contact"
                            role="tab" aria-controls="nav-contact" aria-selected="false">NEFT/RTGS</a> -->

                    </div>
                </nav>
                <div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
                    <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">

                        <section class="">
                            <div class="container">
                                <div class="row">
                                    <div class="col-md-12">

                                    </div>
                                </div>
                            </div>
                        </section>
                        <!-- Donate Section Ends -->

                        <!-- Form Section Starts -->
                        <section class="" id="donation-form-section">
                            <div class="container">
                                <div class="row">
                                    <div
                                        class="col-md-12 donate-form-menu text-center personal-info-menu donate-border-red mb-3">
                                        <img src="{{ url('img/donation-images/personal-info-red-icon.png') }}" alt=""
                                            width="100px">
                                        <h5>Personal Info</h5>
                                    </div>
                                    <!-- <div class="col-md-4 donate-form-menu text-center dontaion-menu donate-border-grey">
                                        <img src="{{ url('img/donation-images/donation-red-icon.png') }}" alt=""
                                            width="100px">
                                        <h5>Donation</h5>
                                    </div>
                                    <div class="col-md-4 donate-form-menu text-center finish-menu donate-border-grey">
                                        <img src="{{ url('img/donation-images/finish-red-icon.png') }}" alt=""
                                            width="100px">
                                        <h5>Finish</h5>
                                    </div> -->
                                </div>

                                {!! Form::open(['url'=>'ccavenue/gateway']) !!}

                                <!--  Step 1 Starts -->
                                <div class="row step-1">
                                    <div class="col-md-12">
                                    <h3 class="text-center donation-form-title"><b>The below details are required to share an automated 80G (tax) certificate after your donation</b></h3>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group donate-group mb-md-0">
                                            <label for="first_name">First Name</label>
                                            <input type="text" name="fname" id="first_name"
                                                placeholder="Enter First Name"
                                                class="form-control donate-control input-lg" required="required">
                                        </div>
                                        <div class="col-md-12 anonymous-donar-wrapper">
                                            <label class="switch">
                                                <input type="checkbox" id="as_anonymous" name="as_anonymous">
                                                <span class="slider round"></span>
                                            </label>
                                            <span>Contribute Anonymously</span>
                                            <span id="anonymous-info-msg">Your name will remain anonymous on the fundraiser page</span>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="last_name">Last Name</label>
                                            <input type="text" name="lname" id="last_name" placeholder="Enter Last Name"
                                                class="form-control donate-control input-lg" required="required">
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="donate_email">Email</label>
                                            <input type="email" name="email" id="donate_email" placeholder="Enter Email"
                                                class="form-control donate-control input-lg" required="required">
                                        </div>
                                    </div>


                                    <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="phone_number">Phone Number</label>
                                            <input type="number" name="phone" id="phone_number"
                                                placeholder="Enter Phone Number"
                                                class="form-control donate-control input-lg" required="required">
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="col-md-12 pl-0">
                                            <div class="default-donation-btns donate-group form-group mb-0 pb-0">
                                            <label for="donation_amount">Donation Amount</label><br>
                                                <span class="fixed-donation" data-pay="3500">3500</span>
                                                <span class="fixed-donation" data-pay="7500">7500</span>
                                                <span class="fixed-donation" data-pay="10000">10000</span>
                                                <span class="fixed-donation" data-pay="12500">12500</span>
                                            </div>
                                        </div>
                                        <div class="form-group donate-group">
                                            
                                            <input type="number" name="donation" id="donation_amount"
                                                placeholder="Enter Donation Amount"
                                                class="form-control donate-control input-lg" required="required">
                                        </div>
                                        
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="pan_card_number">PAN CARD</label>
                                            <input type="text" name="pan" id="pan_card_number"
                                                placeholder="Enter Pan Card Number"
                                                class="form-control donate-control input-lg" required="required">
                                        </div>
                                    </div>

                                    <!-- <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="Currency">Currency</label>
                                            <select name="countrycode" id="Currency"
                                                class="form-control donate-control input-lg"
                                                placeholder="Select Currency" required="required">
                                                <option value="INR">Indian Rupee</option>
                                                <option value="INR">Indian Rupee</option>
                                                <option value="INR">Indian Rupee</option>
                                                <option value="INR">Indian Rupee</option>
                                                <option value="INR">Indian Rupee</option>
                                                <option value="INR">Indian Rupee</option>
                                                <option value="INR">Indian Rupee</option>
                                                <option value="INR">Indian Rupee</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="certificate_name">Cheque Details/DD No</label>
                                            <input type="number" name="cheque" id="cheque"
                                                placeholder="Enter Cheque NUMBER"
                                                class="form-control donate-control input-lg" required="required">
                                        </div>
                                    </div> -->
                                    

                                    <!-- <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="personal_message">Personal Message</label>
                                            <textarea name="personalmessage" id="personal_message"
                                                class="form-control donate-control input-lg"
                                                placeholder="Enter your personal message here" rows="1"></textarea>
                                        </div>
                                    </div> -->

                                    <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="personal_message">Enter Your Address</label>
                                            <textarea name="address" id="address"
                                                class="form-control donate-control input-lg"
                                                placeholder="Enter your address" rows="1"></textarea>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="donation_towards">Donation Towards</label>
                                            <select class="form-control donate-control" name="donation_towards" id="donation_towards" required>
                                                <option value="">Select Donation Towards</option>
                                                <option value="Paediatric Kidney Transplant">Paediatric Kidney Transplant</option>
                                                <option value="Adult Kidney Transplant">Adult Kidney Transplant</option>
                                                <option value="Paediatric Uro-Genital Abnormalities">Paediatric Uro-Genital Abnormalities</option>
                                                <option value="Uro-Oncology Treatment">Uro-Oncology Treatment</option>
                                                <option value="Dialysis Treatment">Dialysis Treatment</option>
                                                <option value="Education of Staff children">Education of Staff children</option>
                                                <option value="Donation for OBW - Mr Sukha Ravinder (Treatment Expenses)">Donation for OBW - Mr Sukha Ravinder (Treatment Expenses)</option>
                                                <option value="Others">Others</option>
                                                
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group donate-group mb-md-0 pb-md-0">
                                            <label for="certificate_name">Your Name as it will appear on the
                                                certificate</label>
                                            <input type="text" name="certificatename" id="certificate_name"
                                                placeholder="Enter Your Name"
                                                class="form-control donate-control input-lg" required="required">
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group donate-group mb-md-0 pb-md-0">
                                            <label for="certificate_name">Pay Through</label>

                                            <br>
                                            <input type="radio" name="payment_type" required="required" value="online_payment"> <label for="">DEBIT/CREDIT/NEFT/RTGS/UPI/WALLET</label>
                                            <br>
                                            <input type="radio" name="payment_type" required="required" value="cheque_payment"> <label for="">CHEQUE</label>
                                        </div>
                                    </div>


                                    <div class="col-md-12 text-center mt-4">
                                        <div class="form-group donate-group">
                                            <button class="btn btn-primary btn-rounded" type="submit">Continue</button>
                                        </div>
                                    </div>

                                </div>
                                <!-- Step 2 Ends -->

                                <!--  Step 3 Starts -->
                                <div class="row step-3">
                                    <div class="col-md-12 text-center">
                                        <h3 class="text-danger">Your Transaction was successfully done, Thank you.
                                        </h3>
                                    </div>
                                </div>
                                <!-- Step 3 Ends -->
                                {!! Form::close() !!}
                            </div>
                        </section>
                    </div>

                    <div class="tab-pane fade" id="nav-contact" role="tabpanel" aria-labelledby="nav-contact-tab">
                        <div class="col-md-12">
                            <p><b>Hospital Name:</b> NU TRUST</p>
                            <p><b>Address of the Hospital:</b> C.A.6, 15TH MAIN, 11TH CROSS, PADMANABHANAGAR,
                                Bengaluru-560070.</p><br>
                            <p><b>Name of the Bank where fund transfer is requested:</b> HDFC BANK, PADMANABHANAGAR
                                BRANCH</p>
                            <p><b>Bank Account Number:</b> 08771450000032</p>
                            <p><b>Bank Branch & Address:</b> PADMANABHANAGAR BRANCH NO. 7, PURNIMA, GROUND FLOOR,
                                M.K.PUTTALINGAIAH ROAD, 2ND STAGE, Bengaluru-560070</p>
                            </p>
                            <p><b>Center (Location):</b> PADMANABHANAGAR BRANCH</p>
                            <p><b>MICR Code:</b> 560240030</p>
                            <p><b>NEFT Code:</b> HDFC0000877</p>
                            <p><b>Type of Bank A/c:</b> CURRENT ACCOUNT</p>
                            <p><b>Permanent Account Number:</b> AAATN2049N</p><br>
                            <p><b>Contact No:</b> 080-46699921</p>
                            <p>Dedicated Email ID for Settlement advice communication</p>
                            <ul>
                                <li><a href="mailto:accountshod@nuhospitals.com">accountshod@nuhospitals.com</a></li>
                                <li><a href="mailto:accounts@nuhospitals.com">accounts@nuhospitals.com</a></li>
                            </ul>
                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>
    </div>
    </div>
</section>



<!-- Form Section Ends -->


@endsection
@section('customjs')
<script>
$("#as_anonymous").on("change",function(){
    if($(this).prop('checked')){
        $(this).val("true");
        $("#anonymous-info-msg").css({"display":"block"});
    }else{
        $(this).val("false");
        $("#anonymous-info-msg").hide();
    }
});

$(".fixed-donation").click(function(){
    $(".fixed-donation").removeClass("active");
    var payment = $(this).attr("data-pay");
    $("#donation_amount").val(parseInt(payment));
    $(this).addClass("active");
})

$("#donation_amount").on("keyup", function(){
    $(".fixed-donation").removeClass("active");
})

function imposeMinMax(el){
  
}

let url = new URL(window.location.href);
let searchParams = new URLSearchParams(url.search);

if(searchParams){
    var donation_towards = searchParams.get('donation_towards');
    $("#donation_towards").val(donation_towards);
}
</script>
@endsection