@extends('layouts/main')
@section('page_title')Careers | Apply Now for Staff Nurse & Doctors Job in India at NU Hospitals
 @endsection
@section('page_description')Get a chance to build your career with NU Hospitals, we provide tremendous opportunities to our students to explore, with extensive practical sessions. Visit here for current openings.
 @endsection
@section('canonical')https://www.nuhospitals.com/ @endsection
@section('content')

@section('title')
{{trans('Best Nephrology Treatment Hospital Padmanabhanagar| Bangalore')}}
@stop
@section('description', 'NU Trust Hospitals Bangalore is the best nephrology Bangalore in India offering the best nephrology treatment and care for all types of kidney diseases.')
@section('keywords', 'Best Nephrology Hospital Bangalore, Best Nephrology Treatment Hospital Bangalore, Best Nephrology Hospital Padmanabhanagar, Best Nephrology Treatment Hospital Padmanabhanagar')
<!--==========================
    Hero Section
  ============================-->
  <section class="wow fadeIn" id="get-started">
    <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">

              <div class="carousel-inner" role="listbox">

                <div class="carousel-item  active">
                  <img src="{{ url('img/banner/Web-Banner_Nephrology.jpg') }}" class="w-100">

                </div>


              </div>

            </div>
            <div class="strip"><span>"NU Trust is recognized under Section 80(5)(vi) of the Indian Income Tax Act, 1961, for tax exemption"</span></div>
  </section><!-- #hero -->
  <!--==========================
    Get Started Section
  ============================-->
  <section id="get-started" class="padd-section wow fadeInUp">

    <div class="container">

      <div class="section-title">

        <h2 class=" text-center">Nephrology</h2>
        <p>We are the pioneers in Kidney transplant surgery since we began our transplant services in 1999. Compared to long-term dialysis, a Kidney transplant offers better quality of life, fewer dietary restrictions, lower risk of death and lower overall treatment costs.<br>
We are one of the few centres in India to do ABO blood group incompatible and paediatric kidney transplants.</p>

      </div>
    </div>

    <div class="container">
      <div class="row">
        <div class="accordion w-100" id="accordionExample">
          <div class="card">
            <div class="card-header" id="headingOne">
              <h4 class="mb-0" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                <span class="">
                  Kidney (Renal) Transplant
                </span>
              </h4>
            </div>

            <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
              <div class="card-body">
                <p><b>What Is Renal Transplant?</b></p>
                <p>Kidney (renal) transplantation is a surgical procedure in which a healthy kidney from a person (donor) is removed and placed in a patient (recipient) diagnosed with irreversible advanced kidney disease (End Stage Renal Disease; ESRD).</p>
                <p><b>What are The Types of Renal Transplant?</b></p>
                <p>Kidney transplantation is classified into deceased donor transplantation or living donor transplantation, depending on the source of the donor organ. At NU, we perform both living donor and deceased donor renal transplant.</p>
                <p><b>Who Can Be a Living Donor for Renal Transplant?</b></p>
                <p>Parents, children, siblings, grandparents and spouse can be voluntary kidney donors if their age is between 18 to 60 years (special situations).<br>
                Blood group of the donor should be compatible with that of the recipient. However, ABO incompatible transplants can also be done.<br>
                The donor should be free from long-standing ailments that can affect kidneys in the course of the illness (diabetes mellitus, hypertension etc.) and should have two healthy, normal functioning kidneys. They should not have an infection with blood-borne viruses (Hepatitis B, Hepatitis C or Human Immunodeficiency Virus infections) and they should be psychologically stable to make a decision on kidney donation without coercion.</p>
                <p><b>What happens During a Renal Transplant?</b></p>
                <p>During a renal transplant, the donor’s kidney is placed in a new position, in the right or left lower quadrant of the abdomen. The damaged kidneys of the patient are not removed unless required in certain circumstances. After the transplant, the patient will have to take immunosuppressive drugs life-long.</p>

              </div>
            </div>
          </div>
          <div class="card">
            <div class="card-header" id="headingTwo">
              <h4 class="mb-0" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                <span class="collapsed">
                 Dialysis
                </span>
              </h4>
            </div>
            <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
              <div class="card-body">
                <p>When an end-stage renal failure occurs (that is, when the kidney function is irreversibly reduced to below 15% of normal function), there are two treatment options available: dialysis or a kidney transplant (also known as a renal transplant). There are two types of dialysis: haemodialysis and peritoneal dialysis</p>
                <p><b>Peritoneal Dialysis:</b></p>
                <p>In peritoneal dialysis, the patient’s peritoneum (membrane present inside the abdomen) is used for the purpose of dialysis. Peritoneal dialysis occurs within the patient’s body.<br>
                For peritoneal dialysis, a tube called a catheter is surgically placed through the wall of the patient’s abdomen as a permanent access for peritoneal dialysis. The catheter is usually placed about an inch below and to the side of the navel. About 2 inches to 4 inches of the catheter extends out of the body.<br>
                Through the catheter, the peritoneum is filled with the peritoneal dialysate (fluid with chemicals that helps to remove wastes from the body). The dialysate absorbs the excess water and the waste products. The dialysate remains in the peritoneum for a certain period of time. This is known as dwell time. After this period, the solution, along with the wastes, is drained from the abdomen into a sterile collection bag</p>
                <p><b>Haemodialysis:</b></p>
                <p>For haemodialysis, two needles are inserted into the patient’s arm. One needle withdraws the blood and the other returns the filtered blood to the patient’s body.
                Two needles are inserted into an AV fistula which is created in the upper limb of the patient at least 6 weeks prior.<br>
                The blood, which is withdrawn by the first needle, travels outside the body through the tubing and the dialysis machine then pumps this blood through a filter called a dialyzer, which is attached to the dialysis machine. The dialyzer cleans the blood and it is returned to the patient’s body through the other needle.<br>
                The dialyzer is also called an artificial kidney because it is an artificial replacement for the patient’s damaged kidneys. During the process of haemodialysis, the haemodialysis machine circulates the dialysate (fluid with chemicals that helps to remove wastes from the body) to the artificial kidney. Haemodialysis is typically performed at a dialysis centre.<br>
                Haemodialysis is performed at NU Hospitals with sophisticated equipment (volumetric, bicarbonate machines). We have 14 state-of-the-art machines [13 of them in the haemodialysis unit and 1 in the intensive care unit (ICU)]. A state-of-the-art reverse osmosis plant purifies the water used for haemodialysis. Periodic cultures and endotoxin levels of the reverse osmosis water are performed to ensure good quality of water.</p>

              </div>
            </div>
          </div>
          <div class="card">
            <div class="card-header" id="headingThree">
              <h4 class="mb-0" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                <span class="collapsed">
                  Vascular access
                </span>
              </h4>
            </div>
            <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
              <div class="card-body">
                <p>To do haemodialysis, there should be a vascular access in the form of central line catheter or Arteriovenous Fistula (AVF) or AV Graft.<br>
                Central line catheters are usually inserted in neck or thigh regions. An arteriovenous fistula (AVF) is direct communication between an artery and a vein. It is considered as an abnormality when it happens spontaneously in the body. But for the purpose of long-term haemodialysis, this communication is deliberately created as a surgery.<br>
                Sometimes a synthetic graft needs to be used when the veins are not of good condition or if some segment of vein is narrowed or injured due to previous surgery.</p>
              </div>
            </div>
          </div>
          <div class="card">
            <div class="card-header" id="heading4">
              <h4 class="mb-0" data-toggle="collapse" data-target="#collapse4" aria-expanded="false" aria-controls="collapse4">
                <span class="collapsed">
                  Paediatric Nephrology
                </span>
              </h4>
            </div>
            <div id="collapse4" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
              <div class="card-body">
                <p>Although kidney problems are deemed to be rare in the pediatric age group, a significant number of children do suffer renal problems, both developmental and acquired. Some easily treatable conditions such as Post-Infectious Glomerulonephritis (PIGN) & Steroid-Sensitive Nephrotic Syndrome are more common in childhood.<br>
                Renal conditions unique to children include congenital anomalies of the kidneys & urinary tract (CAKUT), posterior urethral valves, Vesicoureteric Reflux, Voiding Dysfunction, recurrent Urinary Tract Infections & the wide spectrum of renal tubular disorders with presentation as varied as metabolic acidosis and dehydration, failure to thrive, Rickets, recurrent Renal Stones, electrolyte abnormalities &hypertension.<br>
                Many of these conditions cause severe morbidity and/or progress to renal failure if left untreated.<br>
                Appropriate management of renal failure & early initiation of dialysis & renal transplantation is particularly important in children with end-stage renal disease considering the long life expectancy in children. Management of nutrition & immunization also poses challenges in children with kidney disease.<br>
                The Division of Paediatric Nephrology at NU specializes in the diagnosis and management of children with a variety of acute and chronic kidney-related disorders. We evaluate and treat children with Complicated Nephrotic Syndrome, Hypertension, Haematuria, Proteinuria, Renal Tubular Acidosis, Nephrolithiasis, Glomerulonephritis, and Acute and Chronic Kidney Failure. We also provide comprehensive care for paediatric patients with end-stage kidney disease, including care to patients undergoing Peritoneal Dialysis and Haemodialysis, pre-transplant workup and follow-up care of children after kidney transplantation.</p>
              </div>
            </div>
          </div>
          <div class="card">
            <div class="card-header" id="heading5">
              <h4 class="mb-0" data-toggle="collapse" data-target="#collapse5" aria-expanded="false" aria-controls="collapse5">
                <span class="collapsed">
                  Nephro-pathology
                </span>
              </h4>
            </div>
            <div id="collapse5" class="collapse" aria-labelledby="heading5" data-parent="#accordionExample">
              <div class="card-body">
                <p>A comprehensive evaluation of renal biopsies will be performed by a qualified Nephropathologist.<br>
                Renal biopsy is a diagnostic procedure in which a small piece of renal tissue (tissue from the kidneys) is obtained to know the cause of renal failure, to know the cause of proteinuria and to know the severity in some renal diseases like lupus nephritis.<br>
                An ultrasound-guided renal biopsy can be that of the native kidneys or that of the kidney transplant, is routinely performed under local anesthesia in adults but children need general anesthesia. Bedside renal biopsies are performed for sick patients in the ICU and in the ward.<br>
                Patient needs to get admitted on the morning of the procedure & they need to be under complete bed rest for a day after the procedure. He/she can resume normal activities a couple of days after the procedure.
                Some investigations like coagulation parameters need to be checked prior to renal biopsy. Complications like blood in the urine can occur in about 5% of patients. Rarely, the bleeding can be severe enough to warrant another procedure to stop the bleeding.<br>
                On very rare occasions, a repeat renal biopsy may be required if the original biopsy is unsuccessful.</p>
              </div>
            </div>
          </div>
          <div class="card">
            <div class="card-header" id="heading6">
              <h4 class="mb-0" data-toggle="collapse" data-target="#collapse6" aria-expanded="false" aria-controls="collapse6">
                <span class="collapsed">
                  Preventive Nephrology
                </span>
              </h4>
            </div>
            <div id="collapse6" class="collapse" aria-labelledby="heading6" data-parent="#accordionExample">
              <div class="card-body">
                <ul><li>Screening of community periodically.</li>
                    <li>Patient education materials on chronic kidney disease like Brochure, Videos.</li>
                    <li>Continuing Medical Education to Train doctors to identify early kidney disease and prevent kidney diseases.</li></ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

  </section>

@endsection
@section('customjs')

@endsection
