@extends('layouts/main')
@section('page_title')Donation | Apply Now for Staff Nurse & Doctors Job in India at NU Hospitals
@endsection
@section('page_description')Get a chance to build your career with NU Hospitals, we provide tremendous opportunities to
our students to explore, with extensive practical sessions. Visit here for current openings.
@endsection
@section('canonical')https://www.nuhospitals.com/ @endsection
@section('content')
@section('customcss')
<style type="text/css">
.addressbox {
    border: 0px solid;
    margin: 0rem .5rem;
}

@media (min-width: 786px) {
    .addressbox p {
        padding: 0rem 2rem;
    }

    .addressbox h4 {
        padding: 0rem 2rem;
    }
}
.sidebar{
    margin: 0;
    padding: 10px;
    box-shadow: 0px 0px 30px rgb(127 137 161 / 25%);
    background: #fff;
    float: left;
}
.sidebar-menu{
    margin: 0;
    padding: 10px;
}
.sidebar-menu li{
    list-style: none;
    text-align:left;
    line-height: 1.6;
}
.sidebar-menu li a {
    padding: 10px;
    color: #333;
    transition: 0.3s;
    display: block;
    font-size: 14px;
    font-family: "Roboto", sans-serif;
    font-weight: 400;
    transition:0.5s ease;
}
.sidebar-menu li a:hover{
    color:#ec3237;
}
.home-donation-content-wrapper{
    box-shadow: 0px 0px 30px rgb(127 137 161 / 25%);
    background: #fff;
    min-height:200px;
    margin-bottom: 30px;
    float: left;
}
.home-donation-content-wrapper img{
    width: 100%;
    height: 175px;
    object-fit: cover;
}
.clear-filter{
    color: #ec3237;
    cursor: pointer;
    font-size: 12px;
    border-bottom: 1px dashed;
    display: none;
    float: right;
}
.alert-labels-wrapper{
    width: 100%;
    float: left;
    margin-bottom: 15px;
}
.alert-labels{
    color: #fff;
    font-size: 12px;
    padding: 5px 10px;
}
.green-label{
    float: left;
    background: #117f58;
}
.red-label{
    float: right;
    background: #dc2113;
}
.home-donation-content h4,.home-donation-content p {
    text-align:center;
}
.home-donation-content h4{
    justify-content: center;
    display: flex;
    align-items: center;
}
.home-donation-content{
    padding: 10px 15px 30px;
    float: left;
}
.social-share-wrapper{
    text-align: center;
    margin-top: 15px;
}
.share-btn{
    border: 1px solid;
    padding: 3px 10px;
    margin-left: 10px;
    cursor: pointer;
    vertical-align: middle;
    display: inline-block;
    transition:0.3s;
    font-size: 14px;
    color: #333;
    border-radius: 20px;
}
.share-btn.whatsapp:hover{
    background: #25D366;
    color: #fff;
}
.share-btn.facebook:hover{
    background:#1b74e4;
    color:#fff;
}
</style>
@endsection

<!-- Banner Starts -->
<section class="section donate-banner-section">
    <div class="container-fluid">
        <div class="col-md-12 banner-content text-right">
            <h1>Support our campaigns for a
                <br>healthy cause
            </h1>
            <a href="#donation-form-section" class="btn btn-primary btn-rounded mt-3">Donate Now</a>
        </div>
    </div>
</section>
<!-- Banner Ends -->

<!-- Pediatric Section Starts -->

<!-- Education Section Ends -->

<!-- Donate Section Starts -->
<section class="section pt-5">
    <div class="container">
        <div class="row">
            <div class="col-md-12 section-title text-center">
                <h2>Support Our Campaigns</h2>
            </div>
        </div>
        <div class="row">
            <div class="col-md-3 col-lg-3">
                <div class="sidebar">
                    <ul class="sidebar-menu">
                        <li> <a href="javascript:void(0)" onclick="RenderDonationLists('Paediatric Kidney Transplant');">Paediatric Kidney Transplant</a></li>
                        <li><a href="javascript:void(0)" onclick="RenderDonationLists('Adult Kidney Transplant');">Adult Kidney Transplant</a></li>
                        <li><a href="javascript:void(0)" onclick="RenderDonationLists('Paediatric Uro-Genital Abnormalities');">Paediatric Uro-Genital Abnormalities</a></li>
                        <li><a href="javascript:void(0)">Uro-Oncology Treatment</a></li>
                        <li><a href="javascript:void(0)" onclick="RenderDonationLists('Milaap');">Milaap</a></li>
                        <li><a href="javascript:void(0)" onclick="RenderDonationLists('Impact Guru');">Impact Guru</a></li>
                        <li><a href="javascript:void(0)" onclick="RenderDonationLists('Liver Transplant');">Donation for OBW - Mr Sukha Ravinder (Treatment Expenses)</a></li>
                    </ul>
                    <p class="text-right clear-filter" onclick="RenderDonationLists();">Clear Filter  X</p>
                </div>
            </div>
            <div class="col-md-9 col-lg-9">
                <div class="row" id="donations-lists">
            
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Form Section Ends -->


@endsection
@section('customjs')
<script>
var donations_data = [
    {
        title:"Liver Transplant",
        img_src:"Mr-Sukha-Ravinder-Liver-Transplant.jpg",
        short_content:"Sukha Ravinder, a facilities manager at One Bangalore West apartments, has late stage chronic liver disease and needs an early liver transplant. To donate please click below:",
        donate_link:"donations/liver-transplant?donation_towards=Liver Transplant",
        open_new_window:false,
        category:"Liver Transplant"
    },
    {
        title:"Help little Abu afford his four kidney stone removal surgeries!",
        img_src:"Impactguru-help-abhu.jpg",
        short_content:"Until January, 2020 our son Abu Bakar would keep saying how he wishes to make new friends, learn to read and write. Our 2-year-old boy was really excited to join nursery.",
        donate_link:"https://www.impactguru.com/fundraiser/help-abu-bakar-mk-story-v1-as",
        open_new_window:true,
        category:"Impact Guru"
    },
    {
        title:"Help My Daughter Recover Kidney Transplantation",
        img_src:"support-abhinaya-p.jpg",
        short_content:"My name is Parasuram and I am here to raise funds for my daughter Abhinaya. P who is 17 years old. Abhinaya. P lives in Bengaluru, Karnataka with her parents. Abhinaya. P is studying at 1st Puc.",
        donate_link:"https://milaap.org/fundraisers/support-abhinaya-p",
        open_new_window:true,
        category:"Milaap"
    },
    {
        title:"Paediatric Kidney Transplant",
        img_src:"Pediatric kidney-Transplant.png",
        short_content:"A child weighing more than 10 kg can get an adult kidney, as long as the kidney fits in their body.",
        donate_link:"donations/paediatric-kidney-transplant",
        open_new_window:false,
        category:"Paediatric Kidney Transplant"
    },
    {
        title:"Adult Kidney Transplant",
        img_src:"Adult-Kidney-Transplant-1.png",
        short_content:"Renal transplant is carried out for patients with end-stage renal failure that is when the kidney function is irreversibly reduced to below 15% of normal.",
        donate_link:"donations/adult-kidney-transplant",
        open_new_window:false,
        category:"Adult Kidney Transplant"
    },
    {
        title:"Paediatric Uro-genital abnormalities",
        img_src:"uro-gental.png",
        short_content:"Paediatric urogenital disorders can affect the urinary tract or reproductive organs in children. If not corrected on time, these conditions may lead to significant mental, social and disability issues.",
        donate_link:"donations/paediatric-uro-genital-abnormalities",
        open_new_window:false,
        category:"Paediatric Uro-Genital Abnormalities"
    },
    {
        title:"Education for Children",
        img_src:"Education-for-children-1.png",
        short_content:"A good quality education helps children reach their full potential however, for millions of children and youth, it is beyond reach.",
        donate_link:"donations/education-for-children",
        open_new_window:false,
        category:""
    }
];


function shorten(text,max) {
    return text && text.length > max ? text.slice(0,max).split(' ').slice(0, -1).join(' ') : text
}

function RenderDonationLists(filter_val=""){
    var donation_block_html = "";
    $("#donations-lists").html("");
    var donations_list= [];
    if(filter_val !== ""){
        donations_list = donations_data.filter(function(el) {
                return (el.category == filter_val);
            });
        $(".clear-filter").show();
    }else{
        donations_list = donations_data;
        $(".clear-filter").hide();
    }
    $.each(donations_list, function(index,value){

var donation_block =    '<div class="col-md-4">'+
                        '                        <div class="col-md-12 home-donation-content-wrapper">'+
                        '                            <img src="ImgLink" alt=""'+
                        '                                width="100%">'+
                        '<div class="alert-labels-wrapper"><span class="alert-labels red-label">Urgent</span><span class="alert-labels green-label">Tax Benefits</span></div>                            <div class="col-md-12 home-donation-content">'+
                        '                                <h4>Title</h4>'+
                        '                                <p>ShortContent</p>'+
                        '<div class="social-share-wrapper"><a href="whatsapp://send?text=ShareLink>" data-action="share/whatsapp/share" target="_blank" title="Share on whatsapp"><span class="share-btn whatsapp"><i class="fa fa-whatsapp"></i> Share</span></a><a href="http://www.facebook.com/sharer/sharer.php?u=ShareLink" target="_blank"><span class="share-btn facebook"><i class="fa fa-facebook-f"></i> Share</span></a></div>'+
                        '                                <div class="text-center">'+
                        '                                    <a LinkTarget href="DonationLink"'+
                        '                                        class="btn btn-primary btn-rounded mt-4">Donate Now</a>'+
                        '                                </div>'+
                        '                            </div>'+
                        '                        </div>'+
                        '                    </div>';
    var short_heading = shorten(value.title, 40);
    var short_content = shorten(value.short_content, 98);
    if(value.short_content.length >= 100){
        short_content = short_content + "..."
    }
    if(value.title.length >= 40){
        short_heading = short_heading + "..."
    }
    var link_target = "";

    if(value.open_new_window === true){
        link_target = 'target="_blank"';
    }

    donation_block_html += donation_block.replace(/Title/,short_heading)
                           .replace(/ImgLink/,"/img/donation-images/"+value.img_src)
                           .replace(/ShortContent/,short_content)
                           .replace(/DonationLink/,value.donate_link)
                           .replace(/LinkTarget/,link_target)
                           .replace(/ShareLink/g,"https://nutrust.org/"+value.donate_link);

});
$("#donations-lists").html(donation_block_html);
}

RenderDonationLists();
</script>
@endsection