@extends('layouts/main')
@section('page_title')Donation | Apply Now for Staff Nurse & Doctors Job in India at NU Hospitals
@endsection
@section('page_description')Get a chance to build your career with NU Hospitals, we provide tremendous opportunities to
our students to explore, with extensive practical sessions. Visit here for current openings.
@endsection
@section('canonical')https://www.nuhospitals.com/ @endsection
@section('content')
@section('customcss')
<style type="text/css">
    .addressbox {
        border: 0px solid;
        margin: 0rem .5rem;
    }

    @media (min-width: 786px) {
        .addressbox p {
            padding: 0rem 2rem;
        }

        .addressbox h4 {
            padding: 0rem 2rem;
        }
    }

    nav>div a.nav-item.nav-link.active:after {
        display: none;
    }

    .donation-form-title {
        font-size: 18px;
    }

    .switch {
        position: relative;
        display: inline-block;
        width: 50px;
        height: 25px;
    }

    .switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }

    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        -webkit-transition: .4s;
        transition: .4s;
    }

    .slider:before {
        position: absolute;
        content: "";
        height: 18px;
        width: 18px;
        left: 3px;
        bottom: 3px;
        background-color: white;
        -webkit-transition: .4s;
        transition: .4s;
    }

    input:checked+.slider {
        background-color: #21936a;
    }

    input:focus+.slider {
        box-shadow: 0 0 1px #21936a;
    }

    input:checked+.slider:before {
        -webkit-transform: translateX(26px);
        -ms-transform: translateX(26px);
        transform: translateX(26px);
    }

    .slider.round {
        border-radius: 34px;
    }

    .slider.round:before {
        border-radius: 50%;
    }

    .anonymous-donar-wrapper #anonymous-info-msg {
        display: none;
        font-size: 12px;
        font-style: italic;
    }

    .anonymous-donar-wrapper span {
        font-size: 14px;
    }

    .fixed-donation {
        border: 0;
        background: #f2f2f2;
        padding: 5px 15px;
        font-size: 14px;
        font-weight: 600;
        color: #ec3237;
        margin-right: 10px;
        transition: 0.2s;
        cursor: pointer;
    }

    .fixed-donation:hover,
    .fixed-donation.active {
        background: #ec3237;
        color: #fff;
        box-shadow: 0px 5px 14px -2px #7575758c;
    }
    .d_crncy{
    padding: 0px 4px;
    position: relative;
    top: 12px;
    }
    .donate-group #donation_amount {
        width:95% !important;
        float: right;
    }

    @media only screen and (max-width: 900px) {
        .donate-banner-section {
            min-height: auto !important;
        }

        .h1,
        h1 {
            font-size: 2.2rem !important;
        }

    }

    .sel_int_crny {
        width: 20%;
    }

    .custom_mg-tp {
        margin-top: -43px;
    }

    span.error {
        color: red;
    }
    #country_code{
        width : 100% !important;
        padding:4px;
        height: 200px !important;
    overflow-y: auto;
    }
    .phone_code{
        width:93% !important;
        float:right;
    }
    li.country_sel {
    display: flex;
}
.country_sel img {
    margin-right : 5px;
}
</style>
@endsection

@php
$countryArray = array(
	'AD'=>array('name'=>'ANDORRA','code'=>'376'),
	'AE'=>array('name'=>'UNITED ARAB EMIRATES','code'=>'971'),
	'AF'=>array('name'=>'AFGHANISTAN','code'=>'93'),
	'AG'=>array('name'=>'ANTIGUA AND BARBUDA','code'=>'1268'),
	'AI'=>array('name'=>'ANGUILLA','code'=>'1264'),
	'AL'=>array('name'=>'ALBANIA','code'=>'355'),
	'AM'=>array('name'=>'ARMENIA','code'=>'374'),
	'AN'=>array('name'=>'NETHERLANDS ANTILLES','code'=>'599'),
	'AO'=>array('name'=>'ANGOLA','code'=>'244'),
	'AQ'=>array('name'=>'ANTARCTICA','code'=>'672'),
	'AR'=>array('name'=>'ARGENTINA','code'=>'54'),
	'AS'=>array('name'=>'AMERICAN SAMOA','code'=>'1684'),
	'AT'=>array('name'=>'AUSTRIA','code'=>'43'),
	'AU'=>array('name'=>'AUSTRALIA','code'=>'61'),
	'AW'=>array('name'=>'ARUBA','code'=>'297'),
	'AZ'=>array('name'=>'AZERBAIJAN','code'=>'994'),
	'BA'=>array('name'=>'BOSNIA AND HERZEGOVINA','code'=>'387'),
	'BB'=>array('name'=>'BARBADOS','code'=>'1246'),
	'BD'=>array('name'=>'BANGLADESH','code'=>'880'),
	'BE'=>array('name'=>'BELGIUM','code'=>'32'),
	'BF'=>array('name'=>'BURKINA FASO','code'=>'226'),
	'BG'=>array('name'=>'BULGARIA','code'=>'359'),
	'BH'=>array('name'=>'BAHRAIN','code'=>'973'),
	'BI'=>array('name'=>'BURUNDI','code'=>'257'),
	'BJ'=>array('name'=>'BENIN','code'=>'229'),
	'BL'=>array('name'=>'SAINT BARTHELEMY','code'=>'590'),
	'BM'=>array('name'=>'BERMUDA','code'=>'1441'),
	'BN'=>array('name'=>'BRUNEI DARUSSALAM','code'=>'673'),
	'BO'=>array('name'=>'BOLIVIA','code'=>'591'),
	'BR'=>array('name'=>'BRAZIL','code'=>'55'),
	'BS'=>array('name'=>'BAHAMAS','code'=>'1242'),
	'BT'=>array('name'=>'BHUTAN','code'=>'975'),
	'BW'=>array('name'=>'BOTSWANA','code'=>'267'),
	'BY'=>array('name'=>'BELARUS','code'=>'375'),
	'BZ'=>array('name'=>'BELIZE','code'=>'501'),
	'CA'=>array('name'=>'CANADA','code'=>'1'),
	'CC'=>array('name'=>'COCOS (KEELING) ISLANDS','code'=>'61'),
	'CD'=>array('name'=>'CONGO, THE DEMOCRATIC REPUBLIC OF THE','code'=>'243'),
	'CF'=>array('name'=>'CENTRAL AFRICAN REPUBLIC','code'=>'236'),
	'CG'=>array('name'=>'CONGO','code'=>'242'),
	'CH'=>array('name'=>'SWITZERLAND','code'=>'41'),
	'CI'=>array('name'=>'COTE D IVOIRE','code'=>'225'),
	'CK'=>array('name'=>'COOK ISLANDS','code'=>'682'),
	'CL'=>array('name'=>'CHILE','code'=>'56'),
	'CM'=>array('name'=>'CAMEROON','code'=>'237'),
	'CN'=>array('name'=>'CHINA','code'=>'86'),
	'CO'=>array('name'=>'COLOMBIA','code'=>'57'),
	'CR'=>array('name'=>'COSTA RICA','code'=>'506'),
	'CU'=>array('name'=>'CUBA','code'=>'53'),
	'CV'=>array('name'=>'CAPE VERDE','code'=>'238'),
	'CX'=>array('name'=>'CHRISTMAS ISLAND','code'=>'61'),
	'CY'=>array('name'=>'CYPRUS','code'=>'357'),
	'CZ'=>array('name'=>'CZECH REPUBLIC','code'=>'420'),
	'DE'=>array('name'=>'GERMANY','code'=>'49'),
	'DJ'=>array('name'=>'DJIBOUTI','code'=>'253'),
	'DK'=>array('name'=>'DENMARK','code'=>'45'),
	'DM'=>array('name'=>'DOMINICA','code'=>'1767'),
	'DO'=>array('name'=>'DOMINICAN REPUBLIC','code'=>'1809'),
	'DZ'=>array('name'=>'ALGERIA','code'=>'213'),
	'EC'=>array('name'=>'ECUADOR','code'=>'593'),
	'EE'=>array('name'=>'ESTONIA','code'=>'372'),
	'EG'=>array('name'=>'EGYPT','code'=>'20'),
	'ER'=>array('name'=>'ERITREA','code'=>'291'),
	'ES'=>array('name'=>'SPAIN','code'=>'34'),
	'ET'=>array('name'=>'ETHIOPIA','code'=>'251'),
	'FI'=>array('name'=>'FINLAND','code'=>'358'),
	'FJ'=>array('name'=>'FIJI','code'=>'679'),
	'FK'=>array('name'=>'FALKLAND ISLANDS (MALVINAS)','code'=>'500'),
	'FM'=>array('name'=>'MICRONESIA, FEDERATED STATES OF','code'=>'691'),
	'FO'=>array('name'=>'FAROE ISLANDS','code'=>'298'),
	'FR'=>array('name'=>'FRANCE','code'=>'33'),
	'GA'=>array('name'=>'GABON','code'=>'241'),
	'GB'=>array('name'=>'UNITED KINGDOM','code'=>'44'),
	'GD'=>array('name'=>'GRENADA','code'=>'1473'),
	'GE'=>array('name'=>'GEORGIA','code'=>'995'),
	'GH'=>array('name'=>'GHANA','code'=>'233'),
	'GI'=>array('name'=>'GIBRALTAR','code'=>'350'),
	'GL'=>array('name'=>'GREENLAND','code'=>'299'),
	'GM'=>array('name'=>'GAMBIA','code'=>'220'),
	'GN'=>array('name'=>'GUINEA','code'=>'224'),
	'GQ'=>array('name'=>'EQUATORIAL GUINEA','code'=>'240'),
	'GR'=>array('name'=>'GREECE','code'=>'30'),
	'GT'=>array('name'=>'GUATEMALA','code'=>'502'),
	'GU'=>array('name'=>'GUAM','code'=>'1671'),
	'GW'=>array('name'=>'GUINEA-BISSAU','code'=>'245'),
	'GY'=>array('name'=>'GUYANA','code'=>'592'),
	'HK'=>array('name'=>'HONG KONG','code'=>'852'),
	'HN'=>array('name'=>'HONDURAS','code'=>'504'),
	'HR'=>array('name'=>'CROATIA','code'=>'385'),
	'HT'=>array('name'=>'HAITI','code'=>'509'),
	'HU'=>array('name'=>'HUNGARY','code'=>'36'),
	'ID'=>array('name'=>'INDONESIA','code'=>'62'),
	'IE'=>array('name'=>'IRELAND','code'=>'353'),
	'IL'=>array('name'=>'ISRAEL','code'=>'972'),
	'IM'=>array('name'=>'ISLE OF MAN','code'=>'44'),
	'IN'=>array('name'=>'INDIA','code'=>'91'),
	'IQ'=>array('name'=>'IRAQ','code'=>'964'),
	'IR'=>array('name'=>'IRAN, ISLAMIC REPUBLIC OF','code'=>'98'),
	'IS'=>array('name'=>'ICELAND','code'=>'354'),
	'IT'=>array('name'=>'ITALY','code'=>'39'),
	'JM'=>array('name'=>'JAMAICA','code'=>'1876'),
	'JO'=>array('name'=>'JORDAN','code'=>'962'),
	'JP'=>array('name'=>'JAPAN','code'=>'81'),
	'KE'=>array('name'=>'KENYA','code'=>'254'),
	'KG'=>array('name'=>'KYRGYZSTAN','code'=>'996'),
	'KH'=>array('name'=>'CAMBODIA','code'=>'855'),
	'KI'=>array('name'=>'KIRIBATI','code'=>'686'),
	'KM'=>array('name'=>'COMOROS','code'=>'269'),
	'KN'=>array('name'=>'SAINT KITTS AND NEVIS','code'=>'1869'),
	'KP'=>array('name'=>'KOREA DEMOCRATIC PEOPLES REPUBLIC OF','code'=>'850'),
	'KR'=>array('name'=>'KOREA REPUBLIC OF','code'=>'82'),
	'KW'=>array('name'=>'KUWAIT','code'=>'965'),
	'KY'=>array('name'=>'CAYMAN ISLANDS','code'=>'1345'),
	'KZ'=>array('name'=>'KAZAKSTAN','code'=>'7'),
	'LA'=>array('name'=>'LAO PEOPLES DEMOCRATIC REPUBLIC','code'=>'856'),
	'LB'=>array('name'=>'LEBANON','code'=>'961'),
	'LC'=>array('name'=>'SAINT LUCIA','code'=>'1758'),
	'LI'=>array('name'=>'LIECHTENSTEIN','code'=>'423'),
	'LK'=>array('name'=>'SRI LANKA','code'=>'94'),
	'LR'=>array('name'=>'LIBERIA','code'=>'231'),
	'LS'=>array('name'=>'LESOTHO','code'=>'266'),
	'LT'=>array('name'=>'LITHUANIA','code'=>'370'),
	'LU'=>array('name'=>'LUXEMBOURG','code'=>'352'),
	'LV'=>array('name'=>'LATVIA','code'=>'371'),
	'LY'=>array('name'=>'LIBYAN ARAB JAMAHIRIYA','code'=>'218'),
	'MA'=>array('name'=>'MOROCCO','code'=>'212'),
	'MC'=>array('name'=>'MONACO','code'=>'377'),
	'MD'=>array('name'=>'MOLDOVA, REPUBLIC OF','code'=>'373'),
	'ME'=>array('name'=>'MONTENEGRO','code'=>'382'),
	'MF'=>array('name'=>'SAINT MARTIN','code'=>'1599'),
	'MG'=>array('name'=>'MADAGASCAR','code'=>'261'),
	'MH'=>array('name'=>'MARSHALL ISLANDS','code'=>'692'),
	'MK'=>array('name'=>'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF','code'=>'389'),
	'ML'=>array('name'=>'MALI','code'=>'223'),
	'MM'=>array('name'=>'MYANMAR','code'=>'95'),
	'MN'=>array('name'=>'MONGOLIA','code'=>'976'),
	'MO'=>array('name'=>'MACAU','code'=>'853'),
	'MP'=>array('name'=>'NORTHERN MARIANA ISLANDS','code'=>'1670'),
	'MR'=>array('name'=>'MAURITANIA','code'=>'222'),
	'MS'=>array('name'=>'MONTSERRAT','code'=>'1664'),
	'MT'=>array('name'=>'MALTA','code'=>'356'),
	'MU'=>array('name'=>'MAURITIUS','code'=>'230'),
	'MV'=>array('name'=>'MALDIVES','code'=>'960'),
	'MW'=>array('name'=>'MALAWI','code'=>'265'),
	'MX'=>array('name'=>'MEXICO','code'=>'52'),
	'MY'=>array('name'=>'MALAYSIA','code'=>'60'),
	'MZ'=>array('name'=>'MOZAMBIQUE','code'=>'258'),
	'NA'=>array('name'=>'NAMIBIA','code'=>'264'),
	'NC'=>array('name'=>'NEW CALEDONIA','code'=>'687'),
	'NE'=>array('name'=>'NIGER','code'=>'227'),
	'NG'=>array('name'=>'NIGERIA','code'=>'234'),
	'NI'=>array('name'=>'NICARAGUA','code'=>'505'),
	'NL'=>array('name'=>'NETHERLANDS','code'=>'31'),
	'NO'=>array('name'=>'NORWAY','code'=>'47'),
	'NP'=>array('name'=>'NEPAL','code'=>'977'),
	'NR'=>array('name'=>'NAURU','code'=>'674'),
	'NU'=>array('name'=>'NIUE','code'=>'683'),
	'NZ'=>array('name'=>'NEW ZEALAND','code'=>'64'),
	'OM'=>array('name'=>'OMAN','code'=>'968'),
	'PA'=>array('name'=>'PANAMA','code'=>'507'),
	'PE'=>array('name'=>'PERU','code'=>'51'),
	'PF'=>array('name'=>'FRENCH POLYNESIA','code'=>'689'),
	'PG'=>array('name'=>'PAPUA NEW GUINEA','code'=>'675'),
	'PH'=>array('name'=>'PHILIPPINES','code'=>'63'),
	'PK'=>array('name'=>'PAKISTAN','code'=>'92'),
	'PL'=>array('name'=>'POLAND','code'=>'48'),
	'PM'=>array('name'=>'SAINT PIERRE AND MIQUELON','code'=>'508'),
	'PN'=>array('name'=>'PITCAIRN','code'=>'870'),
	'PR'=>array('name'=>'PUERTO RICO','code'=>'1'),
	'PT'=>array('name'=>'PORTUGAL','code'=>'351'),
	'PW'=>array('name'=>'PALAU','code'=>'680'),
	'PY'=>array('name'=>'PARAGUAY','code'=>'595'),
	'QA'=>array('name'=>'QATAR','code'=>'974'),
	'RO'=>array('name'=>'ROMANIA','code'=>'40'),
	'RS'=>array('name'=>'SERBIA','code'=>'381'),
	'RU'=>array('name'=>'RUSSIAN FEDERATION','code'=>'7'),
	'RW'=>array('name'=>'RWANDA','code'=>'250'),
	'SA'=>array('name'=>'SAUDI ARABIA','code'=>'966'),
	'SB'=>array('name'=>'SOLOMON ISLANDS','code'=>'677'),
	'SC'=>array('name'=>'SEYCHELLES','code'=>'248'),
	'SD'=>array('name'=>'SUDAN','code'=>'249'),
	'SE'=>array('name'=>'SWEDEN','code'=>'46'),
	'SG'=>array('name'=>'SINGAPORE','code'=>'65'),
	'SH'=>array('name'=>'SAINT HELENA','code'=>'290'),
	'SI'=>array('name'=>'SLOVENIA','code'=>'386'),
	'SK'=>array('name'=>'SLOVAKIA','code'=>'421'),
	'SL'=>array('name'=>'SIERRA LEONE','code'=>'232'),
	'SM'=>array('name'=>'SAN MARINO','code'=>'378'),
	'SN'=>array('name'=>'SENEGAL','code'=>'221'),
	'SO'=>array('name'=>'SOMALIA','code'=>'252'),
	'SR'=>array('name'=>'SURINAME','code'=>'597'),
	'ST'=>array('name'=>'SAO TOME AND PRINCIPE','code'=>'239'),
	'SV'=>array('name'=>'EL SALVADOR','code'=>'503'),
	'SY'=>array('name'=>'SYRIAN ARAB REPUBLIC','code'=>'963'),
	'SZ'=>array('name'=>'SWAZILAND','code'=>'268'),
	'TC'=>array('name'=>'TURKS AND CAICOS ISLANDS','code'=>'1649'),
	'TD'=>array('name'=>'CHAD','code'=>'235'),
	'TG'=>array('name'=>'TOGO','code'=>'228'),
	'TH'=>array('name'=>'THAILAND','code'=>'66'),
	'TJ'=>array('name'=>'TAJIKISTAN','code'=>'992'),
	'TK'=>array('name'=>'TOKELAU','code'=>'690'),
	'TL'=>array('name'=>'TIMOR-LESTE','code'=>'670'),
	'TM'=>array('name'=>'TURKMENISTAN','code'=>'993'),
	'TN'=>array('name'=>'TUNISIA','code'=>'216'),
	'TO'=>array('name'=>'TONGA','code'=>'676'),
	'TR'=>array('name'=>'TURKEY','code'=>'90'),
	'TT'=>array('name'=>'TRINIDAD AND TOBAGO','code'=>'1868'),
	'TV'=>array('name'=>'TUVALU','code'=>'688'),
	'TW'=>array('name'=>'TAIWAN, PROVINCE OF CHINA','code'=>'886'),
	'TZ'=>array('name'=>'TANZANIA, UNITED REPUBLIC OF','code'=>'255'),
	'UA'=>array('name'=>'UKRAINE','code'=>'380'),
	'UG'=>array('name'=>'UGANDA','code'=>'256'),
	'US'=>array('name'=>'UNITED STATES','code'=>'1'),
	'UY'=>array('name'=>'URUGUAY','code'=>'598'),
	'UZ'=>array('name'=>'UZBEKISTAN','code'=>'998'),
	'VA'=>array('name'=>'HOLY SEE (VATICAN CITY STATE)','code'=>'39'),
	'VC'=>array('name'=>'SAINT VINCENT AND THE GRENADINES','code'=>'1784'),
	'VE'=>array('name'=>'VENEZUELA','code'=>'58'),
	'VG'=>array('name'=>'VIRGIN ISLANDS, BRITISH','code'=>'1284'),
	'VI'=>array('name'=>'VIRGIN ISLANDS, U.S.','code'=>'1340'),
	'VN'=>array('name'=>'VIET NAM','code'=>'84'),
	'VU'=>array('name'=>'VANUATU','code'=>'678'),
	'WF'=>array('name'=>'WALLIS AND FUTUNA','code'=>'681'),
	'WS'=>array('name'=>'SAMOA','code'=>'685'),
	'XK'=>array('name'=>'KOSOVO','code'=>'381'),
	'YE'=>array('name'=>'YEMEN','code'=>'967'),
	'YT'=>array('name'=>'MAYOTTE','code'=>'262'),
	'ZA'=>array('name'=>'SOUTH AFRICA','code'=>'27'),
	'ZM'=>array('name'=>'ZAMBIA','code'=>'260'),
	'ZW'=>array('name'=>'ZIMBABWE','code'=>'263')
);
@endphp


<!-- Banner Starts -->
<section class="section donate-banner-section">
    <div class="container-fluid">
        <div class="col-md-12 banner-content text-right">
            <h1>Support our campaigns for a
                <br>healthy cause
            </h1>
            <a href="#donation-form-section" class="btn btn-primary btn-rounded mt-3">Donate Now</a>
        </div>
    </div>
</section>
<!-- Banner Ends -->
<section class="mt-5">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center">
                <h2>DONATE TO SAVE LIVES / GIVE THE GIFT OF HEALTH</h2>
                <p>Our campaigns are focused on treating and curing a wide range of simple and complex
                    Nephrology-Urology related diseases in children and adults from poor socio-economic status. And with
                    a little bit of your help, we can make a huge difference in the lives of many who cannot afford
                    quality care from the experts. </p>
                <a href="#donation-form-section" class="donate-text">Make Your Donation Now</a>
                <p class="text-center">"NU Trust is recognized under Section 80(5)(vi) of the Indian Income Tax Act,
                    1961, for tax exemption"
                </p>
            </div>
        </div>
    </div>
</section>
@if ($errors->any())
<input type="hidden" id="show_error" class="show_error" value="1">
@endif

<section class="mt-5 mb-5">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 w-100">
                <nav>
                    <div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
                        <a class="nav-item nav-link active" id="nav-home-tab" data-toggle="tab" href="#nav-home" role="tab" aria-controls="nav-home" aria-selected="true">Payment Gateway</a>
                    </div>
                </nav>
                <div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
                    <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">

                        <section class="">
                            <div class="container">
                                <div class="row">
                                    <div class="col-md-12">

                                    </div>
                                </div>
                            </div>
                        </section>
                        <!-- Donate Section Ends -->

                        <!-- Form Section Starts -->
                        <section class="" id="donation-form-section">
                            <div class="container">
                                <div class="row">
                                    <div class="col-md-12 donate-form-menu text-center personal-info-menu donate-border-red mb-3">
                                        <img src="{{ url('img/donation-images/personal-info-red-icon.png') }}" alt="" width="100px">
                                        <h5>Personal Info</h5>
                                    </div>
                                </div>

                                {!! Form::open(['url'=>'ccavenue/gateway']) !!}
                                <!--  Step 1 Starts -->
                                <div class="row step-1">
                                    <div class="col-md-12">
                                        <h3 class="dom_pay text-center donation-form-title"><b>The below details are required to share an automated 80G (tax) certificate after your donation</b></h3>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group donate-group mb-md-0">
                                            <label for="first_name">First Name *</label>
                                            <input type="text" name="fname" id="first_name" placeholder="Enter First Name" value="{{old('fname')}}" class="form-control donate-control input-lg">
                                            @if ($errors->has('fname'))
                                            <span class="error"> Firstname required </span>
                                            @endif
                                        </div>
                                        <div class="col-md-12 anonymous-donar-wrapper">
                                            <label class="switch">
                                                <input type="checkbox" id="as_anonymous" value="{{old('as_anonymous')}}" name="as_anonymous">
                                                <span class="slider round"></span>
                                            </label>
                                            <span>Contribute Anonymously</span>
                                            <span id="anonymous-info-msg">Your name will remain anonymous on the fundraiser page</span>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="last_name">Last Name *</label>
                                            <input type="text" name="lname" id="last_name" placeholder="Enter Last Name" value="{{old('lname')}}" class="form-control donate-control input-lg">
                                            @if ($errors->has('lname'))
                                            <span class="error"> Lastname required </span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="donate_email">Email *</label>
                                            <input type="email" value="{{old('email')}}" name="email" id="donate_email" placeholder="Enter Email" class="form-control donate-control input-lg">
                                            @if ($errors->has('email'))
                                            <span class="error"> Email required </span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="phone_number">Donation *</label>
                                            <div col-md-12>
                                                <input type="radio" name="donation_type" id="donation_type1" value="INR" checked >
                                                <label for="Domestic">Domestic</label>
                                                <input type="radio" name="donation_type" id="donation_type2" value="USD">
                                                <label for="International">International</label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="phone_number" style="display:block">Phone Number *</label>
                                            <input type="hidden" name="country_code_val"  id="country_code_val" value="91">
                                            <img src="{{url('img/flags/in.png')}}" alt="" id="ctry_sel_id" class="up">
                                            <i class="fa fa-arrow-up changes_arrow" aria-hidden="true"></i>
                                           
                                            <input type="number" name="phone" id="phone_number" class="phone_code" value="{{old('phone')}}" placeholder="Enter Phone Number" class="form-control donate-control input-lg">
                                            @if ($errors->has('phone'))
                                            <span class="error"> Phone required </span>
                                            @endif
                                        </div>
                                        <ul name="country_code" id="country_code" style="display:none">
                                            @foreach($countryArray as $key => $ca)
                                            <li class="country_sel"  data-value="{{$ca['code']}}" @if($key == 'IN') selected @endif >
                                               <img   src="{{url('img/flags/'.strtolower($key).'.png')}}" alt="">
                                               <div>{{$ca['name']}}</div> 
                                            </li>
                                            @endforeach
                                            </ul>
                                    </div>

                                    <div class="col-md-6 custom_mg-tp">
                                        <div class="col-md-12 pl-0">
                                            <div class="default-donation-btns donate-group form-group mb-0 pb-0">
                                            <div id="int_crny">
                                                <input type="radio" id="dom_type" name="dom_int_c" value="INR">
                                                <label for="html">INR</label>
                                                <input type="radio" id="int_type" name="dom_int_c" value="USD" checked>
                                                <label for="css">USD</label><br>
                                                </div>
                                                <label for="donation_amount">Donation Amount </label><br>
                                                <div id="dom_crny" class="int_dom_type">
                                                    <span class="fixed-donation" data-pay="3500">3500</span>
                                                    <span class="fixed-donation" data-pay="7500">7500</span>
                                                    <span class="fixed-donation" data-pay="10000">10000</span>
                                                    <span class="fixed-donation" data-pay="12500">12500</span>
                                                </div>
                                                
                                                <!-- <div id="int_crny" class="default-donation-btns" style="display:none"> -->
                                                    <!-- <input type="hidden" value="USD"  name="sel_int_crny" /> -->
                                                    <!-- <select class="sel_int_crny" name="sel_int_crny">
                                                        <option value="USD">USD</option>
                                                        <option value="EUR">EUR</option>
                                                        <option value="GBP">CAD</option>
                                                    </select> -->
                                                <!-- </div> -->
                                            </div>
                                        </div>
                                        <div class="form-group donate-group">

                                          <span class="d_crncy">₹</span>  <input type="number" name="donation" id="donation_amount" value="{{old('donation')}}" placeholder="Enter Donation Amount" class="form-control donate-control input-lg" min="0">
                                            @if ($errors->has('donation'))
                                            <span class="error"> Donation amount required </span>
                                            @endif
                                        </div>

                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="pan_card_number">PAN CARD <span class="dom_pay">*</span></label>
                                            <input type="text" name="pan" id="pan_card_number" value="{{old('pan')}}" placeholder="Enter Pan Card Number" class="form-control donate-control input-lg">
                                            @if ($errors->has('pan'))
                                            <span class="error"> Pan number required </span>
                                            @endif
                                        </div>
                                    </div>

                                    <!-- <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="Currency">Currency</label>
                                            <select name="countrycode" id="Currency"
                                                class="form-control donate-control input-lg"
                                                placeholder="Select Currency" required="required">
                                                <option value="INR">Indian Rupee</option>
                                                <option value="INR">Indian Rupee</option>
                                                <option value="INR">Indian Rupee</option>
                                                <option value="INR">Indian Rupee</option>
                                                <option value="INR">Indian Rupee</option>
                                                <option value="INR">Indian Rupee</option>
                                                <option value="INR">Indian Rupee</option>
                                                <option value="INR">Indian Rupee</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="certificate_name">Cheque Details/DD No</label>
                                            <input type="number" name="cheque" id="cheque"
                                                placeholder="Enter Cheque NUMBER"
                                                class="form-control donate-control input-lg" required="required">
                                        </div>
                                    </div> -->


                                    <!-- <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="personal_message">Personal Message</label>
                                            <textarea name="personalmessage" id="personal_message"
                                                class="form-control donate-control input-lg"
                                                placeholder="Enter your personal message here" rows="1"></textarea>
                                        </div>
                                    </div> -->

                                    <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="personal_message">Enter Your Address *</label>
                                            <textarea name="address" id="address" class="form-control donate-control input-lg" value="{{old('address')}}" placeholder="Enter your address" rows="1"></textarea>
                                            @if ($errors->has('address'))
                                            <span class="error"> Address required </span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group donate-group">
                                            <label for="donation_towards">Donation Towards *</label>
                                            <select class="form-control donate-control" name="donation_towards" id="donation_towards">
                                                <option value="">Select Donation Towards</option>
                                                <option value="Paediatric Kidney Transplant">Paediatric Kidney Transplant</option>
                                                <option value="Adult Kidney Transplant">Adult Kidney Transplant</option>
                                                <option value="Paediatric Uro-Genital Abnormalities">Paediatric Uro-Genital Abnormalities</option>
                                                <option value="Uro-Oncology Treatment">Uro-Oncology Treatment</option>
                                                <option value="Dialysis Treatment">Dialysis Treatment</option>
                                                <option value="Education of Staff children">Education of Staff children</option>
                                                <!--<option value="Donation for OBW - Mr Sukha Ravinder (Treatment Expenses)">Donation for OBW - Mr Sukha Ravinder (Treatment Expenses)</option>-->
                                                <option value="Others">Others</option>

                                            </select>
                                            <input type="text"  name="dnt_other" id="dnt_other" class="form-control donate-control input-lg" placeholder="other" style="display:none">
                                            @if ($errors->has('donation_towards'))
                                            <span class="error"> Donation Towards required </span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="col-md-6 dom_pay">
                                        <div class="form-group donate-group mb-md-0 pb-md-0">
                                            <label for="certificate_name">Your Name as it will appear on the
                                                certificate *</label>
                                            <input type="text" name="certificatename" id="certificate_name" placeholder="Enter Your Name" value="{{old('certificatename')}}" class="form-control donate-control input-lg">
                                            @if ($errors->has('certificatename'))
                                            <span class="error"> Certicate Name required </span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group donate-group mb-md-0 pb-md-0">
                                            <label for="certificate_name">Pay Through *</label>

                                            <br>
                                            <div>
                                                <input type="radio" name="payment_type" value="online_payment"> 
                                                <label for="">
                                                    <span>DEBIT</span>
                                                    <span class="dom_pay">/CREDIT/NEFT/RTGS/UPI/WALLET</span> 
                                                    <span class="int_pay" style="display:none">/ CREDIT CARD</span> 
                                                </label>
                                            </div>
                                            <div class="dom_pay">
                                                <input type="radio" name="payment_type" value="cheque_payment"> <label for="">CHEQUE</label>
                                            </div>
                                            @if ($errors->has('payment_type'))
                                            <span class="error"> Payment Type required </span>
                                            @endif
                                        </div>
                                    </div>


                                    <div class="col-md-12 text-center mt-4">
                                        <div class="form-group donate-group">
                                            <button class="btn btn-primary btn-rounded" type="submit">Continue</button>
                                        </div>
                                    </div>

                                </div>
                                <!-- Step 2 Ends -->

                                <!--  Step 3 Starts -->
                                <div class="row step-3">
                                    <div class="col-md-12 text-center">
                                        <h3 class="text-danger">Your Transaction was successfully done, Thank you.
                                        </h3>
                                    </div>
                                </div>
                                <!-- Step 3 Ends -->
                                {!! Form::close() !!}
                            </div>
                        </section>
                    </div>

                    <div class="tab-pane fade" id="nav-contact" role="tabpanel" aria-labelledby="nav-contact-tab">
                        <div class="col-md-12">
                            <p><b>Hospital Name:</b> NU TRUST</p>
                            <p><b>Address of the Hospital:</b> C.A.6, 15TH MAIN, 11TH CROSS, PADMANABHANAGAR,
                                Bengaluru-560070.</p><br>
                            <p><b>Name of the Bank where fund transfer is requested:</b> HDFC BANK, PADMANABHANAGAR
                                BRANCH</p>
                            <p><b>Bank Account Number:</b> 08771450000032</p>
                            <p><b>Bank Branch & Address:</b> PADMANABHANAGAR BRANCH NO. 7, PURNIMA, GROUND FLOOR,
                                M.K.PUTTALINGAIAH ROAD, 2ND STAGE, Bengaluru-560070</p>
                            </p>
                            <p><b>Center (Location):</b> PADMANABHANAGAR BRANCH</p>
                            <p><b>MICR Code:</b> 560240030</p>
                            <p><b>NEFT Code:</b> HDFC0000877</p>
                            <p><b>Type of Bank A/c:</b> CURRENT ACCOUNT</p>
                            <p><b>Permanent Account Number:</b> AAATN2049N</p><br>
                            <p><b>Contact No:</b> 080-46699921</p>
                            <p>Dedicated Email ID for Settlement advice communication</p>
                            <ul>
                                <li><a href="mailto:accountshod@nuhospitals.com">accountshod@nuhospitals.com</a></li>
                                <li><a href="mailto:accounts@nuhospitals.com">accounts@nuhospitals.com</a></li>
                            </ul>
                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>
    </div>
    </div>
</section>
@endsection
@section('customjs')
<script>
    $("#as_anonymous").on("change", function() {
        if ($(this).prop('checked')) {
            $(this).val("true");
            $("#anonymous-info-msg").css({
                "display": "block"
            });
        } else {
            $(this).val("false");
            $("#anonymous-info-msg").hide();
        }
    });
    $('#donation_towards').change(function(){
        if(this.value == 'Others'){
            $('#dnt_other').show();
        }else{
            $('#dnt_other').hide();
        }
    });

    $('#ctry_sel_id').click(function(e){
        if($(this).hasClass('up')){
            $(this).removeClass('up');
            $(this).addClass('down');
            $('.changes_arrow').removeClass('fa-arrow-up').addClass('fa-arrow-down');
            $('#country_code').show();
        }else{
            $(this).removeClass('down');
            $(this).addClass('up');
            $('.changes_arrow').removeClass('fa-arrow-down').addClass('fa-arrow-up');
            $('#country_code').hide();
        }
    })
    $('.country_sel').click(function(e){
    $('#ctry_sel_id').attr('src',$(this).find('img').attr('src'));
    $c_code =$(this).attr('data-value');
    $('#country_code_val').val($c_code);
    $('#ctry_sel_id').trigger('click');
    });
       
    
    $(document).ready(function(e) {
        if (jQuery('input[name="donation_type"]:checked').val() == 'INR') {
            jQuery('input[name="donation_type"]:checked').trigger('click');
        }
        if (jQuery('#show_error').hasClass('show_error')) {
            jQuery('#donate_tgr').trigger('click');
        }

    });

    $(".fixed-donation").click(function() {
        $(".fixed-donation").removeClass("active");
        var payment = $(this).attr("data-pay");
        $("#donation_amount").val(parseInt(payment));
        $(this).addClass("active");
    })


    $("#int_type").click(function() {
       $('.d_crncy').text('$');
       $('.int_dom_type').hide();
    })
    $("#dom_type").click(function() {
       $('.d_crncy').text('₹');
       $('.int_dom_type').show();
    })
    $("input[name='donation_type']").change(function(e){
        if(this.value == 'USD'){
            $('.d_crncy').text('$');
            $('.int_dom_type').hide();
        }else{
            $('.d_crncy').text('₹');
            $('.int_dom_type').show();
        }
    });
   

    $("#donation_amount").on("keyup", function() {
        $(".fixed-donation").removeClass("active");
    })

    $("input[name='donation_type']").click(function(e) {
        // function data goes here 
        if (this.value == 'INR') {
            // int_crny
            jQuery('#pan_card_number').attr('required', true);
            jQuery('#dom_crny').show();
            jQuery('#int_crny').hide();
            jQuery('.int_pay').hide();
            jQuery('.dom_pay').show();
        } else {
            jQuery('#pan_card_number').attr('required', false);
            jQuery('#dom_crny').hide();
            jQuery('#int_crny').show();
            jQuery('.int_pay').show();
            jQuery('.dom_pay').hide();
        }
    });

    function imposeMinMax(el) {

    }

    let url = new URL(window.location.href);
    let searchParams = new URLSearchParams(url.search);

    if (searchParams) {
        var donation_towards = searchParams.get('donation_towards');
        $("#donation_towards").val(donation_towards);
    }
</script>
@endsection