<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ContactDetails;
use App\Models\TransactionDetails;
use Exception;
use PDF;
use Mail;

class DonationController extends Controller
{
    public function donation() {
        return view('donation');
    }

    public function ccavenueGateway(Request $request){
        
        try {
        //|regex:/(\.edu(\.[a-z]+)?|\.ac\.[a-z]+)$/
        $validator = $request->validate([
            'fname' => 'required',
            'lname' => 'required',
            'email' => 'required|email',
            'phone' => 'required|numeric',
            'donation' => 'required',
            'pan' => ($request->donation_type != 'USD') ? 'required' : '',
            'address' => 'required',
            'donation_towards' => 'required',
            'certificatename' => ($request->donation_type != 'USD') ? 'required' : '',
            'payment_type' => 'required'
        ]);
        // if ($validator->fails()) {
        //     return self::index($request)->withErrors($validator->errors());
        // }
        // dd($request->all());
        $donationId = floor(time()-rand(99,999));
        $contact = new ContactDetails;
        $contact->donation_id=$donationId;
        $contact->first_name=$request->fname; 
        $contact->last_name=$request->lname;
        $contact->email=$request->email;
        $contact->mobile=$request->phone;
        $contact->amount=$request->donation;
        $contact->address=$request->address;
        $contact->pan_card=$request->pan;
        $contact->certificate_name=$request->certificatename;
        $contact->personal_message=$request->donation_towards;
        $contact->country_code=$request->country_code_val;
        $contact->other=  empty($request->dnt_other) ? null : $request->dnt_other;
        $contact->donar_type = $request->donation_type == 'USD' ? 'International' : 'Domestic';
        $contact->donar_currency = $request->donation_type == 'USD' ? $request->dom_int_c : 'INR';
        $contact->currency= $request->donation_type == 'USD' ? $request->dom_int_c : 'INR';
        $contactSave = $contact->save();

        $transaction = new TransactionDetails;
        $transaction->donation_id = $donationId;
        $transaction->contact_id = $contact->id;
        $transaction->transaction_ip_adderess = $request->ip();
        $transaction->save();
        if($request->payment_type == 'online_payment'){
            session()->put(['contactId'=>$contact->id]);
            return CcavenueController::ccavenue();
        }else{
            return view('cheque-payment-thankyou');
        }
    }catch (Exception $e) {
        return view('error');
    }
        
    }
    public function toCcavenueGateway(Request $request, CcavenueController $ccavenue)
    {
       return $ccavenue->redirectToCCavenueGateway($_POST);
    }
    public function ccavenueINRResponce(Request $request)
    {
        // dd($request);
        return CcavenueController::ccavenueResponceFromINRGateway($request);
    }
    public function ccavenueUSDResponce(Request $request)
    {
        // dd($request);
        return CcavenueController::ccavenueResponceFromUSDGateway($request);
    }

    public function successPayment($id) {
        $contactId = session()->get('contactId');
        $donationId = session()->get('donationId');
        $transactionDetails = TransactionDetails::where('donation_id','=',$donationId)
                    ->where('contact_id','=',$contactId)->first();
        return view('donation_success',['transactionDetails'=>$transactionDetails]);
    }
    public function failPayment($id) {
        $contactId = session()->get('contactId');
        $donationId = session()->get('donationId');
        $transactionDetails = TransactionDetails::where('donation_id','=',$donationId)
                    ->where('contact_id','=',$contactId)->first();
        return view('donation_fail',['transactionDetails'=>$transactionDetails]);
    }
}