<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ContactDetails;
use App\Models\TransactionDetails;
use App\Models\CustomSerial;
use PDF;
use Mail;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;
use Carbon\Carbon;

class CcavenueController extends Controller
{
    //==============CCAVENUE=======================//
    public static function encrypt($plainText, $key)
    {
        $key = self::hextobin(md5($key));
        $initVector = pack("C*", 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
        $openMode = openssl_encrypt($plainText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);
        $encryptedText = bin2hex($openMode);
        return $encryptedText;
    }

    public static function decrypt($encryptedText, $key)
    {
        $key = self::hextobin(md5($key));
        $initVector = pack("C*", 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
        $encryptedText = self::hextobin($encryptedText);
        $decryptedText = openssl_decrypt($encryptedText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);
        return $decryptedText;
    }
    //*********** Padding Function *********************

    public static function pkcs5_pad($plainText, $blockSize)
    {
        $pad = $blockSize - (strlen($plainText) % $blockSize);
        return $plainText . str_repeat(chr($pad), $pad);
    }

    //********** Hexadecimal to Binary function for php 4.0 version ********

    public static function hextobin($hexString)
    {
        $length = strlen($hexString);
        $binString = "";
        $count = 0;
        while ($count < $length) {
            $subString = substr($hexString, $count, 2);
            $packedString = pack("H*", $subString);
            if ($count == 0) {
                $binString = $packedString;
            } else {
                $binString .= $packedString;
            }

            $count += 2;
        }
        return $binString;
    }

    public static function ccavenue()
    {
        $contactId = session()->get('contactId');
        $contactDetails = ContactDetails::findOrFail($contactId);
        $string = NULL;
        $transactionDetails = $contactDetails->donation_id;
        $price = $contactDetails->amount;
        $donation_currency_type = $contactDetails->donar_currency;
        $donar_type = $contactDetails->donar_type;
        $inr_currenct = false;
        if ($donation_currency_type == 'INR' and $donar_type=='Domestic') { // Currency INR only (Domestic donar only)
            $merchant_data = '683274';
            $working_key = '5E2FAAA1098D28505B13E27B00111231'; //Shared by CCAVENUES
            $access_code = 'AVIC52IJ24BD98CIDB'; //Shared by CCAVENUES
            $inr_currenct = true;
        } else { // Currency USD only (International donar only)
            $merchant_data = '254739';
            $working_key = '6B2E6C0D2DBA092ABBCB33C798688853'; //Shared by CCAVENUES
            $access_code = 'AVRQ07ID30BN22QRNB'; //Shared by CCAVENUES
            $inr_currenct = false;
        }


        session()->put(['donationId' => $transactionDetails]);
        $string = '<script>
        window.onload = function() {
                var d = new Date().getTime();
                document.getElementById("tid").value = d;
                };
        </script>';
        $string .= '<body onload="document.frm1.submit();">';
        $string .= "<form name='frm1' method='post' action='" . url('ccavenue/redirecttoccavenuegateway') . "'>";
        $string .= '<input type="hidden" name="_token" value = "' . csrf_token() . '">';
        $string .= '<input type="hidden" name="tid" id="tid" value="" />';
        $string .= '<input type="hidden" name="merchant_id" value="' . $merchant_data . '"/>';
        $string .= '<input type="hidden" name="merchant_param1" value="' . $contactId . '"/>';
        //$string .='<input type="hidden" name="merchant_param2" value="'.$xregTransactionDetails.'"/>';
        $string .= '<input type="hidden" name="order_id" value="' . $transactionDetails . '"/>';
        $string .= '<input type="hidden" id="amount" name="amount" value="' . $price . '"/>';
        $string .= '<input type="hidden" name="currency" value="' . $donation_currency_type . '"/>';
        if ($inr_currenct) {
            $string .= "<input type='hidden' name='redirect_url' value='" . url('ccavenue/payment/inr/ccavenueresponce') . "'/>";
            $string .= "<input type='hidden' name='cancel_url' value='" . url('ccavenue/payment/inr/ccavenueresponce') . "'/>";
        } else {
            $string .= "<input type='hidden' name='redirect_url' value='" . url('ccavenue/payment/usd/ccavenueresponce') . "'/>";
            $string .= "<input type='hidden' name='cancel_url' value='" . url('ccavenue/payment/usd/ccavenueresponce') . "'/>";
        }

        $string .= '<input type="hidden" name="merchant" value="' . $merchant_data . '"/>';
        $string .= '<input type="hidden" name="accessCode" value="' . $access_code . '"/>';
        $string .= '<input type="hidden" name="workingKey" value="' . $working_key . '"/>';
        $string .= '<input type="hidden" name="language" value="EN"/>';
        $string .= "</form>";
        $string .= '</body>';
        return $string;
    }

    public function redirectToCCavenueGateway($arr)
    {
        $contactId = session()->get('contactId');
        $contactDetails = ContactDetails::findOrFail($contactId);

        $donation_currency_type = $contactDetails->donar_currency;
        $donar_type = $contactDetails->donar_type;
        if ($donation_currency_type == 'INR' and $donar_type=='Domestic') { // Currency INR only (domastic only)
            $merchant_data = '683274';
            $working_key = '5E2FAAA1098D28505B13E27B00111231'; //Shared by CCAVENUES
            $access_code = 'AVIC52IJ24BD98CIDB'; //Shared by CCAVENUES
        } else { // Currency USD only (international only)
            $merchant_data = '254739';
            $working_key = '6B2E6C0D2DBA092ABBCB33C798688853'; //Shared by CCAVENUES
            $access_code = 'AVRQ07ID30BN22QRNB'; //Shared by CCAVENUES
        }

        $merchant_data = NULL;
        foreach ($arr as $key => $value) {
            $merchant_data .= $key . '=' . $value . '&';
        }

        $encrypted_data = self::encrypt($merchant_data, $working_key); // Method for encrypting the data.

        echo '<form method="post" name="redirect" action="https://secure.ccavenue.com/transaction/transaction.do?command=initiateTransaction">';
        //echo '<form method="post" name="redirect" action="https://test.ccavenue.com/transaction/transaction.do?command=initiateTransaction">'; 
        echo "<input type=hidden name=encRequest value=$encrypted_data>";
        echo "<input type=hidden name=access_code value=$access_code>";
        echo '</form>';
        echo "<script language='javascript'>document.redirect.submit();</script>";
    }

    public static function ccavenueResponceFromUSDGateway($request)
    {

        $workingKey = '6B2E6C0D2DBA092ABBCB33C798688853';        //Working Key should be provided here.
        $encResponse = $_POST["encResp"];            //This is the response sent by the CCAvenue Server

        $rcvdString = self::decrypt($encResponse, $workingKey); //Crypto Decryption used as per the specified working key.

        $order_status = "";
        $decryptValues = explode('&', $rcvdString);
        $dataSize = sizeof($decryptValues);

        for ($i = 0; $i < $dataSize; $i++) {
            $information = explode('=', $decryptValues[$i]);
            if ((int)$i == 0) {
                $order_id = $information[1];
            }
            if ((int)$i == 1) {
                $trackingId = $information[1];
                // tracking id is present in database
            }
            if ((int)$i == 2) {
                $bank_ref_no = $information[1];
            }
            if ((int)$i == 7) {
                $status_code = $information[1];
            }
            if ((int)$i == 8) {
                $status_message = $information[1];
            }
            if ((int)$i == 4) {
                $failure_message = $information[1];
            }

            if ((int)$i == 3) {
                $order_status = $information[1];
            }

            if ((int)$i == 35) {
                $paidAmountResponse = $information[1];
            }
            if ((int)$i == 26) {
                $merchant_param1 = $information[1];
            }
        }
        //
        $contactId = $merchant_param1;
        $donationId = $order_id;

        $contactDetails = ContactDetails::findOrFail($contactId);

        $amountFromDataBase = $contactDetails->amount;


        if (((string)$order_status == "Success") and ($paidAmountResponse ==  $amountFromDataBase)) {


            $tranx_status_update = array(
                'transaction_status' => 'Paid',
                'gateway_responce_code' => $order_id,
                'gateway_message' => "Payment successfully.",
                'gateway_transaction_id' => $order_id,
                'gateway_auth_code' => $trackingId,
                'trackingId' => $trackingId,
                'transaction_date_time' => Carbon::now()
            );
            TransactionDetails::where('donation_id', '=', $donationId)
                ->where('contact_id', '=', $contactId)
                ->update($tranx_status_update);
            $customSerial = self::getCustomSerial();
            $contactDetails->receipt_number = $customSerial;
            $contactDetails->receipt_date = Carbon::now();
            $contactDetails->save();
            // dd($contactDetails);
            return self::success(1, $contactId, $donationId);
        } else {
            $tranx_status_update = array(
                'transaction_status' => 'UnPaid',
                'gateway_responce_code' => $order_id,
                'gateway_message' => "Transaction not successfully.",
                'gateway_transaction_id' => $order_id,
                'gateway_auth_code' => 00000
            );
            TransactionDetails::where('donation_id', '=', $donationId)
                ->where('contact_id', '=', $contactId)
                ->update($tranx_status_update);

            return self::fail(0, $contactId, $donationId);
        }
    }
    public static function ccavenueResponceFromINRGateway($request)
    {

        $workingKey = '5E2FAAA1098D28505B13E27B00111231';        //Working Key should be provided here.
        $encResponse = $_POST["encResp"];            //This is the response sent by the CCAvenue Server

        $rcvdString = self::decrypt($encResponse, $workingKey); //Crypto Decryption used as per the specified working key.

        $order_status = "";
        $decryptValues = explode('&', $rcvdString);
        $dataSize = sizeof($decryptValues);

        for ($i = 0; $i < $dataSize; $i++) {
            $information = explode('=', $decryptValues[$i]);
            if ((int)$i == 0) {
                $order_id = $information[1];
            }
            if ((int)$i == 1) {
                $trackingId = $information[1];
                // tracking id is present in database
            }
            if ((int)$i == 2) {
                $bank_ref_no = $information[1];
            }
            if ((int)$i == 7) {
                $status_code = $information[1];
            }
            if ((int)$i == 8) {
                $status_message = $information[1];
            }
            if ((int)$i == 4) {
                $failure_message = $information[1];
            }

            if ((int)$i == 3) {
                $order_status = $information[1];
            }

            if ((int)$i == 35) {
                $paidAmountResponse = $information[1];
            }
            if ((int)$i == 26) {
                $merchant_param1 = $information[1];
            }
        }
        //
        $contactId = $merchant_param1;
        $donationId = $order_id;

        $contactDetails = ContactDetails::findOrFail($contactId);

        $amountFromDataBase = $contactDetails->amount;


        if (((string)$order_status == "Success") and ($paidAmountResponse ==  $amountFromDataBase)) {


            $tranx_status_update = array(
                'transaction_status' => 'Paid',
                'gateway_responce_code' => $order_id,
                'gateway_message' => "Payment successfully.",
                'gateway_transaction_id' => $order_id,
                'gateway_auth_code' => $trackingId,
                'trackingId' => $trackingId,
                'transaction_date_time' => Carbon::now()
            );
            TransactionDetails::where('donation_id', '=', $donationId)
                ->where('contact_id', '=', $contactId)
                ->update($tranx_status_update);
            $customSerial = self::getCustomSerial();
            $contactDetails->receipt_number = $customSerial;
            $contactDetails->receipt_date = Carbon::now();
            $contactDetails->save();
            // dd($contactDetails);
            return self::success(1, $contactId, $donationId);
        } else {
            $tranx_status_update = array(
                'transaction_status' => 'UnPaid',
                'gateway_responce_code' => $order_id,
                'gateway_message' => "Transaction not successfully.",
                'gateway_transaction_id' => $order_id,
                'gateway_auth_code' => 00000
            );
            TransactionDetails::where('donation_id', '=', $donationId)
                ->where('contact_id', '=', $contactId)
                ->update($tranx_status_update);

            return self::fail(0, $contactId, $donationId);
        }
    }

    public static function success($data, $contactId, $donationId)
    {
        self::sendEmail($contactId, $donationId);
        return redirect('ccavenue/payment/success/' . encrypt($data));
    }
    public static function fail($data, $contactId, $donationId)
    {
        //self::sendEmail(404, 1676272781);

        return redirect('ccavenue/payment/fail/' . encrypt($data));
    }

    public static function sendEmail($contactId, $donationId)
    {
        require 'PHPMailer/vendor/autoload.php';
        $mail = new PHPMailer(true); // Passing `true` enables exceptions
        // $contactId = session()->get('contactId');
        // $donationId = session()->get('donationId');
        $contactDetails = ContactDetails::findOrFail($contactId);
        $transactionDetails = TransactionDetails::where('donation_id', '=', $donationId)
            ->where('contact_id', '=', $contactId)->first();
        $data["donationId"] = $donationId;
        $data["donar_type"] = $contactDetails->donar_type;
        $data["email"] = $contactDetails->email;
        $data["first_name"] = $contactDetails->first_name;
        $data["last_name"] = $contactDetails->last_name;
        $data["pan_card"] = $contactDetails->pan_card;
        $data["certificate_name"] = $contactDetails->certificate_name;
        $data["personal_message"] = $contactDetails->personal_message;
        $data["receipt_date"] = date('d-m-Y', strtotime($contactDetails->receipt_date));
        $data["receipt_number"] = $contactDetails->receipt_number;
        $data["address"] = $contactDetails->address;
        $data["amount"] = $contactDetails->amount;
        $data["trackingId"] = $transactionDetails->trackingId;
        $data["transaction_date_time"] = date('d-m-Y', strtotime($transactionDetails->transaction_date_time));

        $message = view('email_body', $data)->render();

        //$pdf = PDF::loadView('email_send_template', $data)->setPaper('a4', 'landscape');
        $pdf = PDF::loadView('email_attachment', $data);
        $file_name = md5(rand() . time()) . '.pdf';
        $file_storage_in_store_folder = storage_path($file_name);
        file_put_contents($file_storage_in_store_folder,  $pdf->output());

        try {
            // Mail server settings

            $mail->isSMTP(); // Set mailer to use SMTP
            $mail->Host = 'smtp.gmail.com'; // Specify main and backup SMTP servers
            $mail->SMTPAuth = true; // Enable SMTP authentication
            $mail->Username = 'noreply@nutrust.net'; // SMTP username
            $mail->Password = 'Ab123456789@'; // SMTP password
            $mail->SMTPSecure = 'tls'; // Enable TLS encryption, `ssl` also accepted
            $mail->Port = 587; // TCP port to connect to

            $mail->setFrom('noreply@nutrust.net', 'Donation to NU Trust - Successful ');
            $mail->addAddress($data["email"]); // Add a recipient, Name is optional

            $mail->isHTML(true); // Set email format to HTML

            $mail->Subject = "Donation to NU Trust - Successful ";
            $mail->Body    = $message;
            if($contactDetails->donar_type == 'Domestic'){ // attachment sent only for domestic delegate
                $mail->AddAttachment($file_storage_in_store_folder);
            }

            if (!$mail->send()) {
                // echo 'Message could not be sent.';
                // echo 'Mailer Error: ' . $mail->ErrorInfo;
            } else {
                // echo 'Message has been sent';
            }
        } catch (Exception $e) {
            // return back()->with('error','Message could not be sent.');
        }
    }
    public static  function sendSMS($mobile, $message)
    {
        $url = "https://api.smsu.in/smpp/?";
        $data = array(
            'username' => 'nuhospital',
            'password' => 'nutrans123',
            'from' => 'NUHPTL',
            'to' => '91' . $mobile,
            'text' =>  urlencode($message),
        );

        $params  = http_build_query($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url . $params);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $err = curl_error($ch);

        $res = curl_exec($ch);
        // dd($res);
        curl_close($ch);
        return true;
    }

    public static function getCustomSerial()
    {
        $serial = CustomSerial::where('id', '=', 1)->get()->first();
        $cur_serial = $serial->last_value + 1;
        $prefix = $serial->prefix;
        $formated_serial = $cur_serial;
        for ($x = strlen($cur_serial); $x < 3; $x++) {
            $formated_serial = '0' . $formated_serial;
        }
        CustomSerial::where('id', '=', 1)->update(['last_value' => $cur_serial]);
        return $prefix . $formated_serial;
    }
}
